/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.infernalstudios.infernalexp.client.InfernalExpansionClient;
import org.infernalstudios.infernalexp.config.ConfigHolder;
import org.infernalstudios.infernalexp.data.SpawnrateManager;
import org.infernalstudios.infernalexp.events.MiscEvents;
import org.infernalstudios.infernalexp.events.MobEvents;
import org.infernalstudios.infernalexp.events.WorldEvents;
import org.infernalstudios.infernalexp.init.IEBiomeModifiers;
import org.infernalstudios.infernalexp.init.IEBiomes;
import org.infernalstudios.infernalexp.init.IEBlockEntityTypes;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEBrewingRecipes;
import org.infernalstudios.infernalexp.init.IECapabilities;
import org.infernalstudios.infernalexp.init.IECommands;
import org.infernalstudios.infernalexp.init.IECompostables;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEEntityClassifications;
import org.infernalstudios.infernalexp.init.IEEntityTypes;
import org.infernalstudios.infernalexp.init.IEFireTypes;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IELootModifiers;
import org.infernalstudios.infernalexp.init.IEPaintings;
import org.infernalstudios.infernalexp.init.IEParticleTypes;
import org.infernalstudios.infernalexp.init.IEPotions;
import org.infernalstudios.infernalexp.init.IEProcessors;
import org.infernalstudios.infernalexp.init.IEShroomloinTypes;
import org.infernalstudios.infernalexp.init.IESoundEvents;
import org.infernalstudios.infernalexp.init.IEStructureSets;
import org.infernalstudios.infernalexp.init.IEStructureTypes;
import org.infernalstudios.infernalexp.init.IEStructures;
import org.infernalstudios.infernalexp.init.IESurfaceRules;
import org.infernalstudios.infernalexp.network.IENetworkHandler;
import org.infernalstudios.infernalexp.util.CompatibilityQuark;
import org.infernalstudios.infernalexp.world.gen.ModEntityPlacement;

@Mod(value="infernalexp")
public class InfernalExpansion {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "infernalexp";
    public static final CreativeModeTab TAB = new CreativeModeTab("InfernalTab"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)IEItems.TAB_ITEM.get());
        }
    };

    public InfernalExpansion() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        IEParticleTypes.PARTICLES.register(modEventBus);
        IESoundEvents.register(modEventBus);
        IEBlocks.register(modEventBus);
        IEItems.register(modEventBus);
        IEEffects.register(modEventBus);
        IEPotions.register(modEventBus);
        IEEntityTypes.register(modEventBus);
        IEPaintings.register(modEventBus);
        IEBlockEntityTypes.register(modEventBus);
        IEBiomes.register(modEventBus);
        IELootModifiers.register(modEventBus);
        IEBiomeModifiers.register(modEventBus);
        IEShroomloinTypes.registerAll();
        IEEntityClassifications.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new MiscEvents());
        MinecraftForge.EVENT_BUS.register((Object)new MobEvents());
        MinecraftForge.EVENT_BUS.register((Object)new WorldEvents());
        MinecraftForge.EVENT_BUS.register((Object)new IECapabilities());
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHolder.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHolder.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(IEProcessors::bootstrap);
        event.enqueueWork(IEStructureTypes::register);
        event.enqueueWork(IEStructures::register);
        event.enqueueWork(IEStructureSets::register);
        event.enqueueWork(IESurfaceRules::register);
        event.enqueueWork(IENetworkHandler::register);
        event.enqueueWork(IEBrewingRecipes::register);
        event.enqueueWork(IEFireTypes::register);
        event.enqueueWork(IECompostables::register);
        event.enqueueWork(SpawnrateManager::createResources);
        CraftingHelper.register((IConditionSerializer)new CompatibilityQuark.Serializer());
        ModEntityPlacement.spawnPlacement();
        FlowerPotBlock flowerPot = (FlowerPotBlock)Blocks.f_50276_;
        flowerPot.addPlant(IEBlocks.DULLTHORNS.getId(), IEBlocks.POTTED_DULLTHORNS);
        flowerPot.addPlant(IEBlocks.LUMINOUS_FUNGUS.getId(), IEBlocks.POTTED_LUMINOUS_FUNGUS);
        flowerPot.addPlant(IEBlocks.SHROOMLIGHT_FUNGUS.getId(), IEBlocks.POTTED_SHROOMLIGHT_FUNGUS);
        DispenserBlock.m_52672_((ItemLike)Items.f_42525_, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                ServerLevel world = source.m_7727_();
                BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ItemStack itemstack = stack.m_41620_(1);
                if (world.m_8055_(blockpos).m_60734_() == IEBlocks.DIMSTONE.get()) {
                    world.m_46597_(blockpos, Blocks.f_50141_.m_49966_());
                } else if (world.m_8055_(blockpos).m_60734_() == IEBlocks.DULLSTONE.get()) {
                    world.m_46597_(blockpos, ((Block)IEBlocks.DIMSTONE.get()).m_49966_());
                } else {
                    1.m_123378_((Level)world, (ItemStack)itemstack, (int)6, (Direction)((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)), (Position)DispenserBlock.m_52720_((BlockSource)source));
                }
                return stack;
            }
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InfernalExpansionClient.init(arg_0 -> ((FMLClientSetupEvent)event).enqueueWork(arg_0)));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        IECommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getServer().m_129892_().m_82094_());
    }
}

